<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice #<?php echo e($invoice->id); ?></title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; }
        .header { margin-bottom: 20px; }
        .footer { margin-top: 30px; font-size: 12px; color: #666; }
    </style>
</head>
<body>
    <h2>Invoice #<?php echo e($invoice->id); ?></h2>
    <p><strong>Client:</strong> <?php echo e($invoice->user->name); ?></p>
    <p><strong>Email:</strong> <?php echo e($invoice->client_email); ?></p>
    <p><strong>Amount:</strong> RM <?php echo e(number_format($invoice->subtotal, 2)); ?></p>
    <p><strong>Due Date:</strong> <?php echo e(\Carbon\Carbon::parse($invoice->due_date)->format('d/m/Y')); ?></p>
    <hr>

    <div class="footer">
        <p>Thank you.</p>
    </div>
</body>
</html>
<?php /**PATH D:\website-subscription-management\backend\resources\views/pdf/invoice.blade.php ENDPATH**/ ?>