<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DiscountController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\ReminderController;
use App\Http\Controllers\RevenueController;
use App\Http\Controllers\SubscriptionController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use SebastianBergmann\CodeCoverage\Report\Html\Dashboard;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');



Route::post('/clients', [AuthController::class, 'create']);

Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->middleware('auth:sanctum');;


Route::get('/dashboard', [DashboardController::class, 'show']);
Route::post('/subscription/{user}', [SubscriptionController::class, 'store']);
Route::get('/subscription/{user}', [SubscriptionController::class, 'showById']);
Route::post('/subscription', [SubscriptionController::class, 'storeSubscriptionAdmin']);
Route::get('/subscriptions', [SubscriptionController::class, 'show']);
Route::delete('/subscription/{package}', [SubscriptionController::class, 'destroy']);
Route::post('/subscription/renew/{subscription}', [SubscriptionController::class, 'renewalAndExpiredSubscriptionPayment']);


Route::post('/admins', [AuthController::class, 'createAdmin']);
Route::post('/login-admin', [AuthController::class, 'loginAdmin']);
Route::get('/users', [DashboardController::class, 'showData']);
Route::put('/users/{user}', [DashboardController::class, 'update']);
Route::get('/users/report', [DashboardController::class, 'reportsData']);
Route::get('/payment/{user}', [RevenueController::class, 'showPayment']);
Route::post('/admin/invoices/generate', [InvoiceController::class, 'generate']);
Route::patch('/override/{subscription}', [SubscriptionController::class, 'overrideTerminatedClient']);

Route::prefix('/discount-codes')->group(function () {
    Route::get('/', [DiscountController::class, 'index']);
    Route::post('/', [DiscountController::class, 'store']);
    Route::delete('/{discount}', [DiscountController::class, 'destroy']);
});
Route::prefix('/reminders')->group(function () {
    Route::patch('/{subscription}', [ReminderController::class, 'toggle']);
    Route::post('/', [ReminderController::class, 'sendManual']);
});
Route::get('/invoice/{revenue}', [InvoiceController::class, 'download']);


