<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice From Pemaju Digital</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            margin: 0;
            padding: 20px;
            font-size: 14px;
            color: #333;
        }
        .section {
            border: 1px solid #eee;
            border-radius: 8px;
            padding: 15px 20px;
            margin-bottom: 20px;
        }
        .title {
            font-weight: bold;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            font-size: 16px;
        }
        .title svg {
            margin-right: 8px;
        }
        .row {
            display: flex;
            justify-content: space-between;
            flex-wrap: wrap;
        }
        .col {
            width: 48%;
            margin-bottom: 10px;
        }
        .info-label {
            font-weight: bold;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 5px;
        }
        table th, table td {
            border-bottom: 1px solid #ddd;
            text-align: left;
            padding: 8px;
        }
        table th {
            font-weight: bold;
            font-size: 13px;
        }
        .summary {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
            text-align: center;
        }
        .summary div {
            flex: 1;
            border: 1px solid #eee;
            padding: 10px;
        }
        .summary strong {
            display: block;
            margin-bottom: 5px;
        }
    </style>
</head>
<body>

    {{-- Seller --}}
    <div class="section">
        <div class="title">Seller</div>
        <div class="row">
            <div class="col">
                <p><span class="info-label">Legal name:</span> PEMAJU DIGITAL SDN. BHD.</p>
                <p><span class="info-label">Brand name:</span> PEMAJU DIGITAL SDN. BHD.</p>
                <p><span class="info-label">Reg. No.:</span> 202101019555 (1419855-K)</p>
                <p><span class="info-label">Support email:</span> pemajudigital@gmail.com</p>
                <p><span class="info-label">Support phone:</span> +60 182954919</p>
            </div>
            <div class="col">
                <p><span class="info-label">Invoice:</span> CH{{ $invoice->id }}</p>
                <p><span class="info-label">Issued on:</span> {{ $invoice->created_at->format('M d, Y') }}</p>
                <p><span class="info-label">Due on:</span> {{ $invoice->created_at->format('M d, Y') }}</p>
            </div>
        </div>
    </div>

    {{-- Buyer --}}
    <div class="section">
        <div class="title">Buyer</div>
        <p><span class="info-label">Email:</span> {{ $invoice->user->email }}</p>
    </div>

    {{-- Products --}}
    <div class="section">
        <div class="title">Products</div>
        <table>
            <thead>
                <tr>
                    <th>PRODUCT</th>
                    <!-- <th>QUANTITY</th> -->
                    <th>PRICE</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ $invoice->name }}</td>
                    <td>RM {{ number_format($invoice->subtotal, 2)}}</td>
                </tr>
            </tbody>
        </table>
    </div>

    {{-- Totals --}}
    <div class="summary flex justify-center">
        <div>
            <strong>TOTAL</strong>
           RM RM {{ number_format($invoice->subtotal, 2)}}
        </div>
        <div>
            <strong>DISCOUNT</strong>
            {{ $invoice->discount ? ($invoice->discount->type === 'fixed' 
                ? 'RM' . number_format($invoice->discount->value, 2) 
                : $invoice->discount->value . '%') : ''}}
        </div>

        <div>
            <strong>LATE FEE CHARGE</strong>
           RM {{  number_format($invoice->late_fees, 2) }}
        </div>
    </div>

</body>
</html>
