<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('revenue_id')->nullable()->constrained()->cascadeOnDelete();
            $table->string('item_name');
            $table->string('client_email');
            $table->enum('status', ['Pending','Paid','Failed'])->default('Pending');
            $table->decimal('subtotal', 12, 2);
            // $table->decimal('discount', 12, 2)->default(0);
            $table->foreignId('discount_id')->nullable()->constrained()->cascadeOnDelete();
            $table->decimal('late_fee', 12, 2)->default(0);
            $table->date('due_date')->nullable();
            $table->timestamp('paid_at')->nullable();
            $table->string('pdf_path')->nullable();       // storage path to invoice PDF
            $table->string('message')->nullable();       // storage path to invoice PDF
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
