<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $t) {
            $t->id();
            // $t->foreignId('invoice_id')->constrained()->cascadeOnDelete()->nullable;
            $t->foreignId('subscription_id')->constrained()->cascadeOnDelete();
            $t->dateTime('attempt_date');
            $t->string('chip_purchase_id')->nullable();                    // e.g. CHIP / Stripe
            $t->string('chip_recurring_purchase_id')->nullable();                    // e.g. CHIP / Stripe
            $t->string('transaction_id')->nullable();
            $t->decimal('amount', 12, 2);
            $t->enum('status', ['success','failed','pending'])->default('pending');
            $t->string('receipt_pdf_path')->nullable();
            $t->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
