<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('revenues', function (Blueprint $table) {
            $table->id();
            $table->string('month'); // e.g., "2025-08"
            $table->decimal('revenue', 12, 2)->default(0);
            $table->decimal('late_fees', 12, 2)->default(0);
            $table->foreignId('discount_id')->nullable()->constrained()->onDelete('cascade')->default(null);
            $table->enum('status', ['success','failed']);
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->integer('transactions')->default(0);
            $table->timestamp('generated_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('revenue');
    }
};
