<?php

namespace Database\Factories;
use Illuminate\Support\Str;


use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Discount>
 */
class DiscountFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        
        $type = $this->faker->randomElement(['percent', 'fixed']);

        return [
            'code' => strtoupper(Str::random(8)), // random unique code
            'type' => $type,
            'status' => $this->faker->randomElement(['active', 'inactive']),
            'value' => $type === 'percent'
                ? $this->faker->numberBetween(5, 50) // % between 5–50
                : $this->faker->randomFloat(2, 5, 200), // fixed RM 5 – 200
            'valid_from' => $this->faker->dateTimeBetween('-1 month', 'now'),
            'valid_to' => $this->faker->dateTimeBetween('now', '+2 months'),
            'usage_limit' => $this->faker->optional()->numberBetween(10, 100),
            'used_count' => $this->faker->numberBetween(0, 10),
        ];
    }
}
