<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{


    use HasFactory;
    protected $fillable = [
        'user_id', 'package_id', 'start_date', 'end_date', 'status', 'domain','auto-reminder', 'late_fee', 'city', 'state', 'payment_attempt', 'renew_attempt', 'discount_id'
    ];

    // 🔗 Relationships
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function package()
    {
        return $this->belongsTo(Package::class);
    }
    public function discount()
    {
        return $this->belongsTo(Discount::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function reminders()
    {
        return $this->hasMany(Reminder::class);
    }
}
