<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    protected $fillable = ['client_email', 'subtotal', 'due_date', 'status', 'user_id', 'message', 'item_name', 'discount_id', 'late_fee', 'revenue_id'];


    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function discount()
    {
        return $this->belongsTo(Discount::class);
    }
}

