<?php

namespace App\Http\Controllers;

use App\Models\Reminder;
use App\Models\Subscription;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ReminderController extends Controller
{
    public function toggle(Request $request, Subscription $subscription)
    {

        $sub = Subscription::findOrFail($subscription->id);
        $sub->auto_reminder = $request->reminderStatus;
        $sub->save();

        return response()->json(['message' => 'Reminder updated successfully']);
    }

    // Manual reminder
    public function sendManual(Request $request)
    {
        $validated = $request->validate([
            'email' => 'required|email',
            'message' => 'required|string',
            'subject' => 'required|string',
        ]);

        $user = User::where('email', $validated['email'])->firstOrFail();

        // Example via email
        Mail::raw($validated['message'], function ($mail) use ($user, $validated) {
            $mail->to($user->email)
                ->subject($validated['subject']);
        });

        Reminder::create([
            'user_id' => $user->id,
            'reminder_type' => 'email', 
            'status' => 'sent',
            'reminder_date' => now()
        ]);

        return response()->json(['message' => 'Reminder sent to ' . $user->email]);
    }
}
