<!DOCTYPE html>
<!--<html>-->
<!--<head>-->
<!--    <meta charset="utf-8">-->
<!--    <title>Invoice #<?php echo e($invoice->id); ?></title>-->
<!--    <style>-->
<!--        body { font-family: DejaVu Sans, sans-serif; }-->
<!--        .header { margin-bottom: 20px; }-->
<!--        .footer { margin-top: 30px; font-size: 12px; color: #666; }-->
<!--    </style>-->
<!--</head>-->
<!--<body>-->
<!--    <h2>Invoice #<?php echo e($invoice->id); ?></h2>-->
<!--    <p><strong>Client:</strong> <?php echo e($invoice->user->name); ?></p>-->
<!--    <p><strong>Email:</strong> <?php echo e($invoice->client_email); ?></p>-->
<!--    <p><strong>Amount:</strong> RM <?php echo e(number_format($invoice->subtotal, 2)); ?></p>-->
<!--    <p><strong>Due Date:</strong> <?php echo e(\Carbon\Carbon::parse($invoice->due_date)->format('d/m/Y')); ?></p>-->
<!--    <hr>-->

<!--    <div class="footer">-->
<!--        <p>Thank you.</p>-->
<!--    </div>-->
<!--</body>-->
<!--</html>-->


<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width,initial-scale=1"/>
  <title>Invoice</title>
  <style>
    /* Simple, print-friendly invoice styles */
    body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial; color: #111; margin: 0; padding: 20px; background: #f6f7fb; }
    .sheet { max-width: 900px; margin: 0 auto; background: white; padding: 28px; border-radius: 8px; box-shadow: 0 6px 18px rgba(20,20,40,0.06); }
    header { display:flex; justify-content:space-between; align-items:flex-start; margin-bottom: 20px; }
    .title { font-size:28px; font-weight:700; letter-spacing: -0.5px; }
    .meta { font-size:14px; color:#333; }
    .two-col { display:flex; gap: 20px; margin-bottom: 8px; }
    .col { flex:1; margin-top:8px;}
    .box { background:#fafafa; padding:12px; border-radius:6px; border:1px solid #eee; font-size:14px; }
    h4 { margin:0 0 8px 0; font-size:15px; }
    table { width:100%; border-collapse:collapse; margin-top:12px; }
    th, td { padding:10px 12px; border-bottom:1px solid #eee; text-align:left; font-size:14px; }
    th { background: #fafafa; font-weight:600; }
    tfoot td { border-top:2px solid #e6e6e6; font-weight:700; }
    .right { text-align:right; }
    .small { font-size:13px; color:#555; }
    .bank { margin-top:14px; font-size:14px; }
    .notes { margin-top:18px; font-size:13px; color:#444; }
    .badge { display:inline-block; padding:6px 10px; border-radius:6px; background:#eef6ff; color:#0a58ca; font-weight:600; }
    @media print {
      body { background: white; padding: 0; }
      .sheet { box-shadow: none; border-radius: 0; margin: 0; }
    }
  </style>
</head>
<body>
  <div class="sheet">
    <header>
      <div>
        <div class="title">Invoice</div>
        <div class="small" style="margin-top:6px;"><?php echo e($invoice['title_note'] ?? ''); ?></div>
      </div>
      <div class="meta">
        <div><strong>Date:</strong> <?php echo e(now()->format('F j, Y')); ?></div>
        <div><strong>Due Date:</strong> <?php echo e($invoice['due_date']); ?></div>
      </div>
    </header>

    <div class="two-col">
      <div class="col">
        <h4>Bill From:</h4>
        <div class="box">
          <strong>PEMAJU DIGITAL SDN. BHD.</strong><br>
        </div>
      </div>

      <div class="col">
        <h4>Bill To:</h4>
        <div class="box">
          <strong><?php echo e($invoice->user->name); ?></strong><br>
        </div>
      </div>
    </div>

    <table aria-label="Invoice items">
      <thead>
        <tr>
          <th>Item Name</th>
          <th class="right">Total (RM)</th>
        </tr>
      </thead>
      <tbody>
          <tr>
            <td>
              <div><strong><?php echo e($invoice['item_name']); ?></strong></div>
            </td>
            <td class="right"><?php echo e(number_format($invoice->subtotal, 2)); ?></td>
          </tr>
      </tbody>
    </table>

    <div class="bank">
      <h4>Payment Instructions:</h4>
      <p> Please make the payment to the following bank account:</p>
      <div>
        <strong>Bank Name:</strong> CIMB Bank Berhad / CIMB Islamic Bank Berhad<br>
        <strong>Account Name:</strong> PEMAJU DIGITAL SDN. BHD.<br>
        <strong>Account Number:</strong> 8605058057
      </div>
    </div>
    
  </div>
</body>
</html>

<?php /**PATH /home/airbuahc/public_html/website-subscription-management-system/resources/views/pdf/invoice.blade.php ENDPATH**/ ?>