<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('discount_id')->nullable()->constrained()->onDelete('cascade');
            $table->boolean('auto_reminder')->default(1);
            $table->string('state');
            $table->string('payment_attempt')->nullable();
            $table->string('renew_attempt')->nullable();
            $table->string('city');
            $table->date('next_retry_date')->nullable(); //nullable
            $table->foreignId('package_id')->nullable()->constrained()->onDelete('cascade');
            $table->date('start_date');
            $table->date('end_date');
            $table->decimal('late_fee', 5, 2)->nullable();
            $table->enum('status', ['active', 'expired', 'terminated', 'pending'])->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
};
