<?php

namespace App\Services;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Domain;
use App\Models\Package;
use App\Models\Payment;
use App\Models\Revenue;
use App\Models\Subscription;



use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;

class ChipService
{
    public function firstCharge(string $email,string $websitePackagePrice,$subscriptionPackageName) 
    {

        $token   = config('services.chip.secret_key');
        $baseUrl = config('services.chip.base_url');
        $brandId = config('services.chip.brand_id');
        $frontEndURL = env('FRONTEND_URL');

        // dd(Subscription::whereDate('next_charge_date', '<=', today())->get());

        // Step 1: Create a new purchase
        $create = Http::withToken($token)->post($baseUrl . 'purchases/', [
            'client' => ['email' => $email],
            'purchase' => [
                'products' => [['name' => $subscriptionPackageName . ' subscription', 'price' => $websitePackagePrice]],
            ],
            'brand_id' => $brandId,
            'send_receipt' => true,
            'force_recurring' => true,
            'is_recurring_token' => true,
            'payment_method_whitelist' => ['visa', 'mastercard'],
        ]);

        Log::info('Creating package', ['price' => (float) $websitePackagePrice]);

       
        return [true, 'checkout_url' => $create->json('checkout_url'), 'purchase_id' => $create->json('id')] ;
        
    }


    public function chargeMonthly() 
    {

        $subs = Subscription::whereDate('end_date', '<', today())
    ->whereNotIn('status', ['pending', 'in progress'])
    ->get();
        
        foreach ($subs as $sub) {
            
            $today = now()->startOfDay();
            $paymentAttempted = Payment::where('subscription_id', $sub->id)
            ->whereDate('attempt_date', $today)->first();
            
            if(!$paymentAttempted){
                
                $latestPayment = Payment::where('subscription_id', $sub->id)
                    ->latest('attempt_date')
                    ->first();
                
                $latestPayment->update(['attempt_date' => $today]);

                $basePrice = $sub->package->price;
                $lateFeePercent = 0; 
                $lateFeeAmount = 0;
    
                if($sub->late_fee > 0) {
                    $lateFeePercent = $sub->late_fee;
                    $lateFeeAmount = $basePrice * $lateFeePercent;
                }
    
                $totalPrice = $basePrice + $lateFeeAmount;
                // Step 1: Create purchase, not PAID
                $createResponse = Http::withToken(config('services.chip.secret_key'))
                    ->post(config('services.chip.base_url').'purchases/', [
                        'client' => ['email' => $sub->user->email],
                        'purchase' => [
                            'currency' => 'MYR',
                            'products' => [['name' => $sub->package->name, 'price' => $totalPrice * 100]]
                        ],
                        'brand_id' => config('services.chip.brand_id'),
                        'send_receipt' => true,
                    ]
                );
    
                $newPurchaseId = $createResponse->json('id');
                
                // Step 2: Charge the new purchase using the saved recurring token
                $chargeResponse = Http::withToken(config('services.chip.secret_key'))
                ->post(config('services.chip.base_url')."purchases/{$newPurchaseId}/charge/", [
                    'recurring_token' => $sub->payments[0]->chip_purchase_id,
                    // recurring_token' => null,
                    ]
                );
                
                if ($chargeResponse->successful()) {
                    $sub->payments[0]->update([
                        'attempt_date' => now(),
                        'chip_recurring_purchase_id' => $newPurchaseId,
                        'amount' => $totalPrice,
                    ]);
                    return ['success' => true, 'message' => 'Payment successful'];
                    
                }else{
                    
                     if($sub->late_fee === null){
                        Revenue::create([
                            'month' => now()->format('m'),
                            'revenue' => $totalPrice,
                            'user_id' => $sub->user_id,
                            'status' => 'failed'
                        ]);
                    }else{
                        Revenue::create([
                            'month' => now()->format('m'),
                            'late_fees' =>$totalPrice,
                            'user_id' => $sub->user_id,
                            'status' => 'failed'
                        ]);
                    }
                    
                }
                
                return ['success' => false, 'message' => $chargeResponse->body()];
            }
            
       }   


    }




    public function renewalAndExpiredSubscriptionCharge(string $email, string $websitePackageName, $websitePackagePrice) 
    {

        $token   = config('services.chip.secret_key');
        $baseUrl = config('services.chip.base_url');
        $brandId = config('services.chip.brand_id');
        $appURL = env('APP_URL');
        
        $create = Http::withToken($token)->post($baseUrl . 'purchases/', [
            'client' => ['email' => $email],
            'purchase' => [
                'products' => [['name' => $websitePackageName, 'price' => $websitePackagePrice * 100]],
            ],
            'brand_id' => $brandId,
            'send_receipt' => true,
            'force_recurring' => true,
            'is_recurring_token' => true,
            'payment_method_whitelist' => ['visa', 'mastercard'],
            // 'redirect_url' => env('FRONTEND_URL') . '/dashboard',
        ]);

        if ($create->failed()) {
            logger()->error('Failed to create monthly purchase', [
                'email' => $email,
                'token' => $token,
            ]);
        }
        Log::info('testing:' . now()->toDateTimeString(), ['days left' => $create['id']]);

        return ['result' => true, 'checkout_url' => $create->json('checkout_url'), 'id' => $create['id']];


    }
}





// <!-- $ tail -f storage/logs/laravel.log -->
?>

