<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use App\Models\Discount;

class ValidDiscountCode implements Rule
{
    public function passes($attribute, $value)
    {
        $discount = Discount::where('code', $value)->first();

        if (!$discount) {
            return false; // not exist
        }

        $now = now();

        // Check start date
        if ($discount->valid_from && $now->lt($discount->valid_from)) {
            return false;
        }

        // Check end date
        if ($discount->valid_to && $now->gt($discount->valid_to)) {
            return false;
        }

        // Check usage limit
        if ($discount->usage_limit > 0 && $discount->used_count >= $discount->usage_limit) {
            return false;
        }

        // Check status
        if ($discount->status !== 'active') {
            return false;
        }

        return true;
    }

    public function message()
    {
        return 'Invalid code';
    }
}
