<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Auth\Notifications\ResetPassword;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
       ResetPassword::createUrlUsing(function ($notifiable, $token) {
        $frontendUrl = env('FRONTEND_URL');

        return $frontendUrl."/auth/reset-password?token={$token}&email={$notifiable->getEmailForPasswordReset()}";
    });
    }
}
