<?php

namespace App\Notifications;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class CheckSubscriptions extends Notification
{
    use Queueable;

    protected $subscription;

    /**
     * Create a new notification instance.
     */
    public function __construct($subscription)
    {
        $this->subscription = $subscription;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
   public function toMail(object $notifiable): MailMessage
{
    $packageName = $this->subscription->package ? $this->subscription->package->name : "custom";
    $expiryDate = Carbon::parse($this->subscription->end_date)->format('F j, Y');
    $userName = $this->subscription->user->name;

    return (new MailMessage)
        ->subject("Payment Reminder: Website Management System")
        ->greeting("Hi {$userName},")
        ->line("Just a reminder: your subscription for the {$packageName} will expire on {$expiryDate}.")
        ->action('Renew Now', url('/renew/' . $this->subscription->id))
        ->line('Thank you for using our application!');
}

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
