<?php

namespace App\Notifications;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class AdminReminderMail extends Notification
{
    use Queueable;

    protected $email;
    protected $subject;
    protected $message;

    /**
     * Create a new notification instance.
     */
    public function __construct($email,$subject,$message)
    {
        $this->email = $email;
        $this->subject = $subject;
        $this->message = $message;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
   public function toMail(object $notifiable): MailMessage
{

    return (new MailMessage)
        ->subject($this->subject)
        ->greeting("Hi {$this->email},")
        ->line("Just a reminder: {$this->message}")
        // ->action('Renew Now', url('/renew/29'))
        ->line('If you have any questions or need assistance, feel free to contact us on pemajudigital@gmail.com.');
        // ->subject($this->subject)
        // ->greeting("Hi {$this->email},")
        // ->line($this->message)
        // ->line('If you have any questions or need assistance, feel free to contact us on pemajudigital@gmail.com.');
}

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
