<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Revenue extends Model
{
    /** @use HasFactory<\Database\Factories\RevenueControllerFactory> */
    use HasFactory;


    protected $fillable = [
        'month',
        'revenue',
        'user_id',
        'package_id',
        'late_fees',
        'transactions',
        'status',
        'discount_id'
    ];


    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
