<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    protected $fillable = [
        'user_id', 'subscription_id', 'invoice_id', 'amount',
        'discount_id', 'status', 'payment_date', 'payment_gateway',
        'attempt_date', 'message', 'chip_purchase_id', 'chip_recurring_purchase_id'
    ];

    // 🔗 Relationships
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function subscription()
    {
        return $this->belongsTo(Subscription::class);
    }

    public function discount()
    {
        return $this->belongsTo(Discount::class);
    }

    public function invoice()
    {
        return $this->hasOne(Invoice::class);
    }
}
