<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Discount extends Model
{
    use HasFactory;

    protected $fillable = [
        'code', 'type', 'value', 'valid_from', 'valid_to', 'usage_limit', 'used_count','status', 
    ];

    // 🔗 Relationships
    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function isValid()
    {
        $now = now();
        return $this->status === 'active'
            && (!$this->valid_from || $now->gte($this->valid_from))
            && (!$this->valid_to || $now->lte($this->valid_to))
            && ($this->usage_limit != 0 || $this->usage_count < $this->usage_limit);
    }
}
