<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Mail\Mailables\Content;



class AdminReminderMail extends Mailable
{
    use Queueable, SerializesModels;

    public $adminSubject;
    public $message;
    public $email;

    /**
     * Create a new message instance.
     */
    public function __construct($adminSubject, $message, $email )
    {
        $this->adminSubject = $adminSubject;
        $this->message = $message;
        $this->email = $email;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject($this->adminSubject)
                    ->markdown('emails.reminder');
    }
    
     public function envelope(): Envelope
    {
        return new Envelope(
            subject: $this->adminSubject,
        );
    }
    
     public function content(): Content
    {
        return new Content(
            markdown: 'emails.reminder',
        );
    }
    
    public function attachments(): array
    {
        return [];
    }
}
