<?php

namespace App\Http\Controllers;

use App\Models\Invoice;
use App\Models\Package;
use App\Models\Payment;
use App\Models\Revenue;
use App\Models\Subscription;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class WebhookController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    public function handleChipWebhook(Request $request)
    {

        // if (!$this->isValidSignature($request)) {
        //     Log::warning('CHIP webhook invalid signature', ['ip' => $request->ip()]);
        //     return response()->json(['message' => 'Invalid signature'], 400);
        // }


        $purchaseId = $request->input('id');
        $status = $request->input('status');
        
        // if ($status === 'paid') {
        //     // logger()->critical('Webhook failed at ' . now()->toDateTimeString(), [
        //     //     'payload' => $status,
        //     //     'reason' => 'just testing',
        //     // ]);
        //     Subscription::where('token', $purchaseId)->update([
        //         'status' => 'paid',
        //         'last_payment_date' => now(),
        //     ]);
        // }

        // 2) Parse payload (contoh struktur payload generik)
        $payload = json_decode($request->getContent(), true);
        $event   = data_get($payload, 'status'); // cth: 'payment.succeeded' / 'payment.failed'
        $amount   = data_get($payload, 'purchase.products.0.price')/100;
        $chipPurchaseToken   = data_get($payload, 'id');
        $chipRecurringToken   = data_get($payload, 'recurring_token');

        // $token = $chipRecurringToken ?? $chipPurchaseToken;
        
        $payment = Payment::where('chip_purchase_id', $chipPurchaseToken)
                    ->orWhere('chip_recurring_purchase_id', $chipPurchaseToken)
                    ->latest()
                    ->first();
                    
                    $subscription = $subscription = Subscription::with('discount')->find($payment->subscription_id);
;
                    
                    Log::info('webhook (webhookController) 59 ' . now()->toDateTimeString(), [
                            'subscription' => $subscription,
                            'chipRecurringToken' => $chipRecurringToken,
                            'chipPurchaseToken' => $chipPurchaseToken,
                            'price' => $amount
                        ]);
        //     // Log::debug('Webhook raw payload', ['payload' => $payload]);
        //     // Log::info('(from webhookController.php) testing:' . now()->toDateTimeString(), ['payment id from chip' => $payment]);
            
            switch ($event) {
                case 'paid':
                    $this->handlePaymentSuccess($subscription, $amount, $payload);
                    break;

            case 'payment_failure':
                $this->handlePaymentFailed($subscription,$chipPurchaseToken, $amount);

            default:
                Log::info('CHIP webhook unhandled status', ['status' => $status]);
                break;
        }

        // return response()->json(['ok' => true]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }


    private function handlePaymentSuccess(Subscription $sub, $amount, array $payload): void
    {

        // $startDate = Carbon::parse($sub->start_date); 
        $currentEndDate = Carbon::parse($sub->end_date);
        $months = (int) $sub->package->duration_months;

        // for renew 
        if ($sub->payment_attempt >= 1) {
            $endDate = $currentEndDate->copy()->addMonths($months);
        } else {
            $startDate = now();
            $endDate   = $currentEndDate;
        }

        if($sub->renew_attempt !== null) {
            $discountId = null;
        }else{
            $discountId = $sub->discount ? $sub->discount->id : null;
        };


        Log::info('webhook (webhookController) 59 ' . now()->toDateTimeString(), [
            'price' => $amount
        ]);

        if($sub->late_fee === null){
          $revenue =   Revenue::create([
                'month' => now()->format('m'),
                'revenue' => $amount,
                'user_id' => $sub->user_id,
                'status' => 'success',
                'discount_id' => $discountId
            ]);
        }else{
          $revenue =    Revenue::create([
                'month' => now()->format('m'),
                'late_fees' =>$amount,
                'user_id' => $sub->user_id,
                'status' => 'success',
                'discount_id' => $discountId
            ]);
        }
        Invoice::create([
            'user_id' => $sub->user_id,
            'item_name' => $sub->package ? $sub->package->name : 'custom',
            'client_email' => $sub->user->email,
            'subtotal' => $amount,
            'status' => 'Paid',
            'discount_id' => $discountId,
            'late_fee' => $sub->late_fee !== null ? $sub->late_fee : 0,
            'due_date' => now(),
            'paid_at' => now(),
            'revenue_id' => $revenue->id
        ]);
        
        
        
        $sub->update([
            'status' => 'active',
            'start_date' => now(),
            'end_date' => $endDate,
            'late_fee' => null,
            'next_retry_date' => null,
            'discount_id' => $discountId,
            'payment_attempt' => $sub->payment_attempt ? $sub->payment_attempt + 1 : 1
        ]);
        
        Payment::where('subscription_id', $sub->id)
        ->update([
            'attempt_date' => now(),
            'status' => 'success'
        ]);


        
        // $amount = (float) $amount;
        // Log::info('webhook (webhookController) 59 ' . now()->toDateTimeString(), [
        //     'amount' => $amount,
        // ]);
        
        // Revenue::create([

        // ])

        
    }

    private function handlePaymentFailed(Subscription $sub, $chipPurchaseId, $amount): void 
    {
        $sub->payments()->create([
            'subscription_id' => $sub->id,
            'chip_purchase_id' => $chipPurchaseId,
            'amount' => $amount,
            'attempt_date' => now(),
            'status' => 'failed',
        ]);
              if($sub->late_fee === null){
            Revenue::create([
                'month' => now()->format('m'),
                'revenue' => $amount,
                'user_id' => $sub->user_id,
                'status' => 'failed'
            ]);
        }else{
            Revenue::create([
                'month' => now()->format('m'),
                'late_fees' =>$amount,
                'user_id' => $sub->user_id,
                'status' => 'failed'
            ]);
        }
    }
}