<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Invoice;
use App\Models\Payment;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Mail\InvoiceGeneratedMail;
use App\Models\Package;
use App\Models\Revenue;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class InvoiceController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Invoice $invoice)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Invoice $invoice)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Invoice $invoice)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Invoice $invoice)
    {
        //
    }
    public function download(Revenue $revenue)
    {
        $invoice = Invoice::where('revenue_id',$revenue->id)->first();
        // $package = Package::where

        // Pass data to Blade view
        $pdf = Pdf::loadView('invoices.template', compact('invoice'));

        // Force download
        return $pdf->download("invoice-{$invoice->id}.pdf");
    }

    public function generate(Request $request)
    {
        
        // dd($request);
        $validated = $request->validate([
            'subtotal' => 'required|numeric',
            'client_email' => 'required|email',
            'due_date' => 'required',
            'item_name' => 'required'
        ]);
        
        $user = User::where('email', $validated['client_email'])->first();
        $latestInvoice = Invoice::latest('id')->first();
        $nextNumber = $latestInvoice ? 'INV-' . str_pad($latestInvoice->id + 1, 4, '0', STR_PAD_LEFT) : 'INV-0001';
        
        $invoice = Invoice::create([
            'item_name' => $validated['item_name'],
            'client_email' => $validated['client_email'],
            'subtotal' => $validated['subtotal'],
            'due_date' => $validated['due_date'],
            'message' => $request->message,
            'user_id' => $user->id,
            'number' => $nextNumber
        ]);
        
        Log::info('testing:' . now()->toDateTimeString(), ['invoice:' => $invoice]);

        Mail::to($validated['client_email'])->send(new InvoiceGeneratedMail($invoice));

        return response()->json([
            'message' => 'Invoice generated and email sent successfully.',
            'invoice' => $invoice
        ]);
    }
}
