<?php

namespace App\Http\Controllers;

use App\Models\Revenue;
use App\Models\Subscription;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class DashboardController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {

     
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request)
    {
        return response()->json(Auth::user());    
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, User $user)
    {
        $user->update(array_filter([
            'name' => $request->input('name'),
            'phone' => $request->input('phone'),
        ]));
       return response()->json(['message' => 'Updated successfully', 'user' => $user]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }


    // admin 

    public function showData()
    {
        $month = Carbon::now()->format('m'); 
        $subscriptions =  Subscription::where('status', '!=', 'pending')->with('user')->get();
        $revenue = Revenue::where('month', $month)
                    ->where('revenue', '>', 0)
                    ->get();
        $lateFee = Revenue::where('month', $month)
                 ->where('late_fees', '>', 0)
                 ->get();


       return [$subscriptions, $revenue, $lateFee];
    }

    public function reportsData(){
        $allSubscriptions = Subscription::get();
        $subscriptions = Subscription::selectRaw('MONTH(created_at) as month, COUNT(*) as total')
        ->groupBy('month')
        ->pluck('total','month');

        $renewalSubscriptions = Subscription::where('renew_attempt', '>', 1)
        ->selectRaw('MONTH(created_at) as month, SUM(renew_attempt) as total')
        ->groupBy('month')
        ->pluck('total','month');

        $outstandingSubscriptions = Subscription::where('status', 'expired')
        ->selectRaw('MONTH(created_at) as month, COUNT(*) as total')
        ->groupBy('month')
        ->pluck('total','month');

        $terminatedClients = Subscription::where('status', 'terminated')->with('user')->get();

        
        $months = [
            1 => "Jan", 2 => "Feb", 3 => "Mar", 4 => "Apr", 5 => "May",
            6 => "Jun", 7 => "Jul", 8 => "Aug", 9 => "Sep", 10 => "Oct",
            11 => "Nov", 12 => "Dec"
        ];

         $chartData = [];
        foreach ($months as $num => $name) {
            $chartData[] = [
                "month" => $name,
                "subscriptions" => $subscriptions[$num] ?? 0,
                "renewals" => $renewalSubscriptions[$num] ?? 0,
                "outstanding" => $outstandingSubscriptions[$num] ?? 0,
            ];
        }

        // On-time revenue (no discount)
        $revenueOnTime = Revenue::whereNull('discount_id')->sum('revenue');
        $revenueLateFee = Revenue::whereNull('discount_id')->sum('late_fees');

        // Discounted revenue
        $revenueDiscount = Revenue::whereNotNull('discount_id')->sum('revenue');
        
        return [
            'allSubscriptions' => $allSubscriptions,
            'chartData' => $chartData,
            'revenue' => $revenueLateFee + $revenueOnTime,
            'discountRevenue' => $revenueDiscount,
            'terminatedClients' => $terminatedClients
        ];
    }
}
