<?php

namespace App\Console\Commands;

use App\Services\ChipService;
use Illuminate\Console\Command;

class ChargeSubscription extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'subscription:charge';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'recurring payment';
    protected ChipService $chipService;


    public function __construct(ChipService $chipService)
    {
        parent::__construct();
        $this->chipService = $chipService;
    }


    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->chipService->chargeMonthly(); 

    }
}
