<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\WebhookController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('home');
});
Route::get('/home', function () {
    return view('home');
})->name('home');
Route::post('/home', [PaymentController::class, 'index']);
Route::delete('/clients/{subscription:client_id}', [SubscriptionController::class, 'destroy']);
Route::post('/purchases', [PaymentController::class, 'create']);
Route::get('/success', [PaymentController::class, 'success']);
Route::get('/failure', [PaymentController::class, 'failure']);
Route::post('/cancel-subscription/{token}', [SubscriptionController::class, 'destroy']);
Route::post('/chip/webhook', [WebhookController::class, 'handleChipWebhook']);


Route::get('/schedule-run', [PaymentController::class, function () {
    return Artisan::call('schedule:run');
}]);


Route::get('/test-log', function () {
    Log::error('Custom error in scheduled task', [
        'exception' => new \Exception('Something went wrong')
    ]);

    return 'Error logged!';
});


Route::get('/card-details/{subscription:email}', [PaymentController::class, 'showUpdateCard']);
Route::patch('/card-details/{subscription:email}', [PaymentController::class, 'updateCard']);




Route::get('login', [AuthController::class, 'index'])->name('login');
Route::post('post-login', [AuthController::class, 'postLogin'])->name('login.post'); 
Route::get('/dashboard', [AdminController::class, 'showDashboard'])->middleware('auth');

