<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Laravel 12 Custom Dashboard - ItSolutionStuff.com</title>
  </head>
<body>
    
<main>
    

    <div class="p-5 mb-4 bg-light rounded-3">
      <div class="container-fluid py-5">

        @session('success')
            <div class="alert alert-success" role="alert"> 
              {{ $value }}
            </div>
        @endsession

        <h1 class="display-5 fw-bold">Hi {{ auth()->user()->name }}, welcome to dashboard page</h1>
        <table border="1" cellpadding="8" cellspacing="0" style="border-collapse: collapse; width:100%; text-align:left;">
          <thead style="background-color: #f2f2f2;">
              <tr>
                  <th>Email</th>
                  <th>Last Payment</th>
                  <th>Next Retry Payment Date</th>
                  <th>Status</th>
              </tr>
          </thead>
          <tbody>
              @foreach($subscriptions as $sub)
                  <tr>
                      <td>{{ $sub['email'] }}</td>
                      <td>{{ $sub['last_payment_date'] ?? 'N/A' }}</td>
                      <td>{{ $sub['next_retry_date'] }}</td>
                      <td>
                          @php
                              $color = match(true) {
                                  $sub['status'] === 'paid' => '#28a745', // green
                                  $sub['status'] === 'overdue' && $sub['days_overdue'] <= 10 => '#ffc107', 
                                  $sub['status'] === 'overdue' && $sub['days_overdue'] > 10 => '#dc3545', 
                                  $sub['status'] === 'suspended' => '#6c757d', // gray
                                  default => '#007bff' // blue
                              };
                          @endphp
      
                          <span style="display:inline-block; padding:4px 10px; border-radius:12px; font-size:12px; font-weight:bold; color:white; background-color:{{ $color }};">
                              {{ ucfirst($sub['status']) }}
                              @if($sub['days_overdue'] !== null)
                                  ({{ $sub['days_overdue'] > 0 ? $sub['days_overdue'] : 0 }} days overdue)
                              @endif
                          </span>
                      </td>
                  </tr>
              @endforeach
          </tbody>
      </table>
      
      
      
      </div>
    </div>

</main>

</body>
</html>