<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body>

  <h2 class="fs-6 fw-normal text-center text-secondary mb-4">Sign in</h2>
  <form method="POST" action="{{ route('login.post') }}">
    @csrf

    @session('error')
            {{ $value }}
    @endsession

    <div class="row gy-2 overflow-hidden">
      <div class="col-12">
        <div class="form-floating mb-3">
          <input type="name" name="name" id="name" placeholder="name" required>
          <label for="name" class="form-label">{{ __('name') }}</label>
        </div>
        @error('name')
                <strong>{{ $message }}</strong>
        @enderror
      </div>
      <div class="col-12">
        <div class="form-floating mb-3">
          <input type="password" name="password" id="password" value="" placeholder="Password" required>
          <label for="password" class="form-label">{{ __('Password') }}</label>
        </div>
        @error('password')
                <strong>{{ $message }}</strong>
        @enderror
      </div>
      <div class="col-12">
        <div class="d-grid my-3">
          <button class="btn btn-primary btn-lg" type="submit">{{ __('Login') }}</button>
        </div>
      </div>
    </div>
  </form>

</body>
</html>