<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'resend' => [
        'key' => env('RESEND_KEY'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],
    
    'chip' => [
        'secret_key' => env('CHIP_SECRET_KEY'),
        'brand_id' => env('CHIP_BRAND_ID'),
        'base_url' => env('CHIP_BASE_URL'),
        'webhook_secret' => env('CHIP_WEBHOOK_SECRET'),
        'signature_header' => env('CHIP_SIGNATURE_HEADER', 'X-Signature'),
        'signature_algo' => env('CHIP_SIGNATURE_ALGO', 'sha256')
    ]

];
