<?php

namespace App\Services;

use App\Models\PaymentAttempts;
use App\Models\Subscription;
use Illuminate\Support\Facades\Http;

class ChipService
{
    public function firstCharge(string $email) :array
    {
        $token   = config('services.chip.secret_key');
        $baseUrl = config('services.chip.base_url');
        $brandId = config('services.chip.brand_id');
        $appURL = env('APP_URL');

        // dd(Subscription::whereDate('next_charge_date', '<=', today())->get());

        // Step 1: Create a new purchase
        $create = Http::withToken($token)->post($baseUrl . 'purchases/', [
            'client' => ['email' => $email],
            'purchase' => [
                'products' => [['name' => 'cuci laptop', 'price' => 1000]],
            ],
            'brand_id' => $brandId,
            'send_receipt' => true,
            'force_recurring' => true,
            'is_recurring_token' => true,
            'payment_method_whitelist' => ['visa', 'mastercard'],
            'redirect_url' => route('home'), 
        ]);



        $purchaseId = $create->json('id');
        $status = $create->json('status');
        $clientId = $create->json('client_id');


        
        if ($create->failed()) {
            logger()->error('Failed to create monthly purchase', [
                'email' => $email,
                'token' => $purchaseId,
                'response' => $status,
            ]);
        }
        
        $existedSubscription = Subscription::where('email', $email)->first();

        if(!$existedSubscription){
          Subscription::create([
                'email' => $email,
                'token' => $purchaseId,
                'recurring_token' => $purchaseId,
                'next_retry_date' => null,
                'next_charge_date' => now()->addDays(31),
                'status' => 'created',
                'client_id' => $clientId,
            ]);
        }
    
        return ['result' => true, 'checkout_url' => $create->json('checkout_url')];
        
    }


    public function chargeMonthly() 
    {

        $dueSubs = Subscription::whereDate('next_charge_date', '<', today())->where('status', "!=","suspended" )->get();

        foreach ($dueSubs as $dueSub) {
            
            $today = now()->startOfDay();
            $paymentAttempted = PaymentAttempts::where('subscription_id', $dueSub->id)
            ->whereDate('attempt_date', $today)->first();
            
            if(!$paymentAttempted){
                
                // Step 1: Create purchase, not PAID
                $createResponse = Http::withToken(config('services.chip.secret_key'))
                    ->post(config('services.chip.base_url').'purchases/', [
                        'client' => ['email' => $dueSub->email],
                        'purchase' => [
                            'currency' => 'MYR',
                            'products' => [['name' => 'cuci laptop', 'price' => 1000]]
                        ],
                        'brand_id' => config('services.chip.brand_id'),
                        'send_receipt' => true,
                    ]
                );
                
                $newPurchaseId = $createResponse->json('id');
                
                // Step 2: Charge the new purchase using the saved recurring token
                $chargeResponse = Http::withToken(config('services.chip.secret_key'))
                ->post(config('services.chip.base_url')."purchases/{$newPurchaseId}/charge/", [
                    'recurring_token' => $dueSub->token,
                    // 'recurring_token' => null,
                    ]
                );
                
                if ($chargeResponse->successful()) {
                    
                    return ['success' => true, 'message' => 'Payment successful'];
                    info(['success' => true, 'message' => 'Payment successful']);
                    
                }
                
                logger()->critical('Webhook failed at ' . now()->toDateTimeString(), [
                    'retry_payment' => 'retry_payment_failed',
                    'message' => $chargeResponse->successful(),
                ]);
                
                return ['success' => false, 'message' => $chargeResponse->body()];
            
            }   
        }

    }
}





// <!-- $ tail -f storage/logs/laravel.log -->
?>

