<?php

namespace App\Notifications;

use App\Models\Subscription;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ServiceSuspendedClient extends Notification
{
    use Queueable;
    protected $subscription;

    /**
     * Create a new notification instance.
     */
    public function __construct(Subscription $subscription)
    {
        $this->subscription = $subscription;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
        ->subject("Subscription Suspended")
        ->greeting('Billing Team,')
        ->line("Your subscription plan has been suspended.")
        ->action('pay now', url('/home'))

        ->line("Suspended date: " . now()->format('d M Y'));
    }

    public function toDatabase($notifiable)
    {
        return [
            'subscription_id' => $notifiable->id,
            'message' => 'Payment reminder sent.',
            'overdue_days' => now()->diffInDays($notifiable->next_charge_date, false) * -1,
        ];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
