<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ServiceSuspended extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct(protected $subscription)
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
        ->subject("Client Suspended - {$this->subscription->email}")
        ->line("Client: {$this->subscription->email}")
        ->line("Subscription has been suspened because the customer failed to make payment after 25 days of overdue date.")
        ->action('See Dashboard', url('/dashboard'));
    }

    public function toDatabase($notifiable)
    {
        return [
            'subscription_id' => $notifiable->id,
            'message' => 'Payment reminder sent.',
            'overdue_days' => now()->diffInDays($notifiable->next_charge_date, false) * -1,
        ];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
