<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ServiceResumedClient extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
        ->subject("✅ Your subscription has been activated")
        ->greeting("Hi Mr/Mrs,")
        ->line("Thanks for the payment for subscription.")
        ->line("Your subscription for cuci laptop's service has been activated automatically.");
    }

    public function toDatabase($notifiable)
    {
        return [
            'subscription_id' => $notifiable->id,
            'message' => 'Payment reminder sent.',
            'overdue_days' => now()->diffInDays($notifiable->next_charge_date, false) * -1,
        ];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
