<?php

namespace App\Notifications;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PaymentReminder extends Notification
{
    use Queueable;

    protected $subscription;
    /**
     * Create a new notification instance.
     */
    public function __construct($subscription)
    {
        $this->subscription = $subscription;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
        ->subject('Payment Subscription Reminder')
        ->greeting('Hello')
        ->line('Your subscription payment failed to process.')
        ->line('Due date: ' .Carbon::parse($this->subscription->next_charge_date)->format('d M Y'))
        ->action('Pay here', url('/home'))
        ->line('If you are not make a payment before ' . $this->getSuspendDate()->format('d M Y') . ', Your service will be suspended.');
    }

    private function getSuspendDate()
    {
        return Carbon::parse($this->subscription->next_charge_date)->addDays(25);
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }

    public function toDatabase($notifiable)
    {
        return [
            'subscription_id' => $notifiable->id,
            'message' => 'Payment reminder sent.',
            'overdue_days' => now()->diffInDays($notifiable->next_charge_date, false) * -1,
        ];
    }
}
