<?php

namespace App\Notifications;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class OverDueBucketChanged extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct( protected $subscription, protected string $bucket )
    {

    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return  ['mail','database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {

        $color = $this->bucket === 'yellow' ? 'YELLOW (1-10 days)' : 'RED (11+ days)';
        return (new MailMessage)
            ->subject("Overdue Alert [{$this->bucket}]")
            ->greeting('Billing Team,')
            ->line("Client {$this->subscription->email} in category {$this->bucket}.")
            ->line("Overdue since: " . Carbon::parse($this->subscription->next_charge_date)->format('d M Y'))
            ->action('Lihat dashboard', url('/dashboard'));
    }

    public function toDatabase($notifiable)
    {
        return [
            'subscription_id' => $notifiable->id,
            'message' => 'Payment reminder sent.',
            'overdue_days' => now()->diffInDays($notifiable->next_charge_date, false) * -1,
        ];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
