<?php

namespace App\Http\Controllers;

use App\Models\Subscription;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class WebhookController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    public function handleChipWebhook(Request $request)
{
    $purchaseId = $request->input('id');
    $status = $request->input('status');
    
        log::info('Webhook failed at ' . now()->toDateTimeString(), [
            'payload' => $status,
            'reason' => 'just testing',
        ]);
        
        
     // 2) Parse payload (contoh struktur payload generik)
     $payload = json_decode($request->getContent(), true);
     $event   = data_get($payload, 'status'); // cth: 'payment.succeeded' / 'payment.failed'
     $client = data_get($payload, 'client.email');
     $price   = data_get($payload, 'purchase.products.0.price');

     $sub = Subscription::where('email', $client)->first();

     if (!$sub) {
        Log::warning('CHIP webhook subscription not found', ['subscription_id' => $sub]);
        return response()->json(['message' => 'Subscription not found'], 404);
    }
    
     switch ($event) {
        case 'paid':
            $this->handlePaymentSuccess($sub, $price, $payload);
            break;

        case 'payment_failure':
            $this->handlePaymentFailed($sub, 'Payment failed', $payload);
            break;

        default:
            Log::info('CHIP webhook unhandled status', ['status' => $status]);
            break;
    }

    return response()->json(['ok' => true]);
}
    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
    
     private function isValidSignature(Request $request): bool
    {
        $publicKey = config('services.chip.webhook_secret'); // This is actually the PEM public key
        $signature = $request->header('X-Signature');
        $payload   = $request->getContent();
    
        if (!$publicKey || !$signature || !$payload) return false;
    
        $decodedSignature = base64_decode($signature);
        $key = openssl_pkey_get_public("-----BEGIN PUBLIC KEY-----\n" . trim($publicKey) . "\n-----END PUBLIC KEY-----");
    
        return openssl_verify($payload, $decodedSignature, $key, OPENSSL_ALGO_SHA256) === 1;
    }

    private function handlePaymentSuccess(Subscription $sub, int $amount, array $payload): void
    {
        $sub->update([
            'status' => 'paid',
            'retry_count' => 0,
            'next_retry_date' => null,
            'last_payment_date' => now(),
            'next_charge_date' => now()->addDays(31),
        ]);

        $sub->paymentAttempts()->create([
            'attempt_date' => now(),
            'attempt_number' => max(1, $sub->retry_count),
            'status' => 'success',
            'message' => 'payment captured via webhook',
        ]);

        if ($sub->wasChanged('status') && $sub->status === 'active') {
            Subscription::where('email', $sub->email)->update([
                'status' => 'paid',
                'retry_count' => 0,
                'next_retry_date' => null,
                'last_payment_date' => now(),
                'next_charge_date' => now()->addDays(31),
            ]);

            $sub->paymentAttempts()->create([
                'attempt_date' => now(),
                'attempt_number' => max(1, $sub->retry_count),
                'status' => 'success',
                'message' => 'payment captured via webhook',
            ]);
        }
    }

    public function handlePaymentFailed(Subscription $sub, string $reason, array $payload): void
    {
        if ($sub->status !== 'suspended') {
            $sub->status = 'overdue';
        }

        $sub->retry_count = min(8, $sub->retry_count + 1);
        $sub->next_retry_date = $this->nextRetryDateFromCount($sub->retry_count);
        $sub->save();

        $sub->paymentAttempts()->create([
            'attempt_date'   => now(),
            'attempt_number' => $sub->retry_count,
            'status'         => 'failed',
            'message'        => $reason,
        ]);

        // Optional: kalau dah melepasi jadual retry (cth. > 8), suspend di sini
        if ($sub->retry_count >= 8) {
            // Hari ke-25 reminder akhir diurus oleh command reminder.
            Subscription::where('email', $sub->email)->update([
                'status' => 'suspended',
            ]);
        }
    }


    private function nextRetryDateFromCount(int $count): ?\Illuminate\Support\Carbon
    {
        return match ($count) {
            1 => now()->addDays(1),
            2 => now()->addDays(2),
            3 => now()->addDays(4), // total 7
            4 => now()->addDays(3), // total 10
            5 => now()->addDays(5), // total 15
            6 => now()->addDays(5), // total 20
            7 => now()->addDays(5), // total 25
            8 => null,
            default => null,
        };
    }
}