<?php

namespace App\Http\Controllers;

use App\Console\Commands\ChargeSubscriptions;
use App\Models\Subscription;
use App\Services\ChipService;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;


class PaymentController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $email = $request->input('email');
        
        $client = DB::table('subscriptions')->where('email', '=', $email)->first();
        
        return view('purchase', ['client' => $client, 'email' => $email]);
       
    }


    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        $email = $request->input('email');
        $today = Carbon::today();

        $client = DB::table('subscriptions')->where([
            ['email', '=', $email],
            ['next_charge_date', '>', $today],
            ['status', '=', 'paid']
        ])->whereNotNull('token')->first();

            // dd($client);
        // Step 3: Redirect based on purchase history
        if (isset($client)) {
            return view('purchase', ['error' => 'You have already subscribed.', 'client' => $client]);
        }


            $email= $request->input('email');
            $chip = new ChipService();
            $success = $chip->firstCharge($email);
            if ($success['result']) {
                return redirect()->away($success['checkout_url']);
            } else {
                return response()->json(['status' => 'failed'], 500);
            }                   
    }


    public function success()
    {
       return view('purchase-success');
    }




    public function handle(Request $request)
    {

        

        $event = $request->input('event');
            app(ChargeSubscriptions::class)->handleSubscriptions();


            logger()->info('CHIP webhook received', ['event' => $event]);
      



    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function showUpdateCard(Request $request, Subscription $subscription)
    {
        $banks = config('banks');
        $subscription = $subscription->where('email', $subscription->email)->firstOrFail();
        // dd($banks);
        
        return view('billing.update', ['banks' => $banks, 'subscription' => $subscription]);
        
        
    }
    public function updateCard(Request $request, Subscription $subscription)
    {
        $token = config('services.chip.secret_key');
        $baseUrl = config('services.chip.base_url');
        $clientId = $subscription->client_id;

        $banks = config('banks');

        $bankCode = $request->input('bank_name');
        $account_number = $request->input('account_number');
        $bankName = array_search($bankCode, $banks);

        // dd($clientId);
        
        https://gate.chip-in.asia/api/v1/clients/{id}/
        // Step 1: Create a new purchase
        $updateClient = Http::withToken($token)->patch($baseUrl . 'clients/'. $clientId.'/', [
            'results' => ['email' => $subscription->email],
            'bank_account' => $account_number, 
            'bank_code' => $bankCode
        ]);

        if ($updateClient->successful()) {
            return redirect()->route('home')->with('success', 'Bank details updated successfully.');
        } else {
            return back()->withErrors(['message' => 'Failed to update bank details.']);
        }

        
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}

