<?php

namespace App\Http\Controllers;

use App\Models\Subscription;
use Carbon\Carbon;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }


    public function showDashboard()
    {
        // show 'overdue' client, green(active/paid), yellow(1-10 days), red(11+ days)
        // show date and status of payment

        // status(show color based on date)
        // last_payment_date

        $subscriptions = Subscription::all()->map(function ($sub) {
            $now = Carbon::now();
    
            $days = floor(now()->diffInDays($sub->next_charge_date, false) * -1);
    
            $color = match (true) {
                $sub->status === 'paid' => 'green',
                $days !== null && $days <= 10 => 'yellow',
                $days !== null && $days > 10 => 'red',
            };
    
            return [
                'email' => $sub->email,
                'next_retry_date' => $sub->next_retry_date,
                'last_payment_date' => $sub->last_payment_date,
                'status' => $sub->status,
                'days_overdue' => $days,
                'color' => $color,
            ];
        });

        
        return view('dashboard', compact('subscriptions'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
