<?php

namespace App\Console\Commands;

use App\Models\Subscription;
use App\Notifications\OverDueBucketChanged;
use Illuminate\Console\Command;
use App\Notifications\PaymentReminder;
use App\Notifications\ServiceSuspendedClient;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Str;



class SendReminders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'payments:send-reminders';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {

        $subs = Subscription::where('status', 'overdue')->get();

        foreach ($subs as $sub) {



            $overdueDays = floor(now()->diffInDays($sub->next_charge_date, false) * -1);

            // $sub->update(['last_notification_date' => null]);

            
            $alreadyNotified = $sub->notifications()
            ->where('type', PaymentReminder::class)
            ->whereDate('created_at', today())
            ->exists();
            
            $alreadyNotifiedStaff = $sub->notifications()
            ->where('type', OverDueBucketChanged::class)
            ->whereDate('created_at', today())
            ->exists();
            
            Log::info('Webhook failed at ' . now()->toDateTimeString(), [
                'already Notified' => $alreadyNotifiedStaff,
                'overduedays' => $overdueDays,
            ]);
            if (!$alreadyNotified) {
                if (in_array($overdueDays, [10, 15, 20])) {
                    // Notification::route('mail', 'muazmn001@gmail.com')
                    //     ->notify(new PaymentReminder($sub));
                    $sub->notify(new PaymentReminder($sub));

                }
            }


            if (!$alreadyNotifiedStaff) {

                if ($overdueDays >= 1 && $overdueDays <= 10) {
                    $this->info("Reminder hantar kepada client {$sub->email} (overdue {$overdueDays} hari).");
                    Notification::route('mail', 'muazpemajudigital@gmail.com')
                        ->notify(new OverDueBucketChanged($sub, 'yellow'));
                        $sub->notifications()->create([
                            'id' => Str::uuid()->toString(),
                            'type' => OverDueBucketChanged::class,
                            'data' => [
                                'subscription_id' => $sub->id,
                                'message' => 'Client overdue alert',
                            ],
                        ]);
                } elseif ($overdueDays >= 11) {
                    Notification::route('mail', 'muazpemajudigital@gmail.com')
                        ->notify(new OverdueBucketChanged($sub, 'red'));
                        $sub->notifications()->create([
                            'id' => Str::uuid()->toString(),
                            'type' => OverDueBucketChanged::class,
                            'data' => [
                                'subscription_id' => $sub->id,
                                'message' => 'Client overdue alert',
                            ],
                        ]);
                }
               
            }
        }
    }
}
