<?php

namespace App\Console\Commands;

use App\Models\Subscription;
use App\Notifications\OverDueBucketChanged;
use App\Notifications\ServiceResumed;
use App\Notifications\ServiceResumedClient;
use App\Notifications\ServiceSuspended;
use App\Notifications\ServiceSuspendedClient;
use App\Services\ChipService;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;


class RetryPayments extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'payments:retry';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $subs = Subscription::whereIn('status', ['overdue', 'suspended'])->get();

        

        foreach($subs as $sub) {
            $overdueDays =(int) floor(now()->diffInDays($sub->next_charge_date, false) * -1);
            $alreadyAttemptedToday = $sub->paymentAttempts()
            ->whereDate('attempt_date', today())
            ->exists();

            $alreadyNotifiedClient = $sub->notifications()
            ->where('type',ServiceSuspendedClient::class)
            ->whereDate('created_at', today())
            ->exists();

            $alreadyNotifiedStaff = $sub->notifications()
            ->where('type',ServiceSuspended::class)
            ->whereDate('created_at', today())
            ->exists();

            $resumeNotifiedClient = $sub->notifications()
            ->where('type',ServiceSuspended::class)
            ->whereDate('created_at', today())
            ->exists();

            $resumeNotifiedStaff = $sub->notifications()
            ->where('type',ServiceSuspended::class)
            ->whereDate('created_at', today())
            ->exists();
            $paymentService = new ChipService();
            $result = $paymentService->chargeMonthly();            
            // Log::info('retryPayment.php', ['result' => $result['success']]);
            Log::info('RetryPayments.php', ['alreadyNotifiedClient' => $alreadyNotifiedClient]);

            
            Log::info('RetryPayments.php', ['overduedays' => $overdueDays]);

            
            
            // Flow retry ikut hari overdue
            if (in_array($overdueDays, [1,3,7,10,15,20, 25])) {

                if (!empty($result['success'])) {
                    if ($sub->status === 'suspended') {
                        if(!$resumeNotifiedStaff){
                            // Notify that service resumed
                            Notification::route('mail', 'muazpemajudigital@gmail.com')
                                ->notify(new ServiceResumed($sub));
                                
                                $sub->notifications()->create([
                                    'id' => Str::uuid()->toString(),
                                    'type' => ServiceResumed::class,
                                    'data' => [
                                    'subscription_id' => $sub->id,
                                    'message' => 'Client resumed',
                                    ],
                                ]);
                        }

                        if(!$resumeNotifiedClient){
                            // Notify that service resumed
                            Notification::route('mail', $sub->email)
                                ->notify(new ServiceResumed($sub));
                                
                                $sub->notifications()->create([
                                    'id' => Str::uuid()->toString(),
                                    'type' => ServiceResumed::class,
                                    'data' => [
                                    'subscription_id' => $sub->id,
                                    'message' => 'Client resumed',
                                    ],
                                ]);          
                        }
                    }
                    // $sub->update([
                    //     'status' => 'paid',
                    //     'retry_count' => 0,
                    //     'next_retry_date' => null,
                    //     'last_payment_date' => now(),
                    //     'next_charge_date' => now()->addDays(31),
                    // ]);
                } else {
                    if(!$alreadyAttemptedToday){
                    $sub->update([
                        'retry_count' => $sub->retry_count + 1,
                        'next_retry_date' => $this->getNextRetryDate($sub->retry_count + 1),
                    ]);
                    
                    $sub->paymentAttempts()->create([
                        'attempt_date' => now(),
                        'attempt_number' => $sub->retry_count + 1, 
                        'status' => !empty($result['success'])  ? 'success' : 'failed',
                        'message' => !empty($result['success']) ?? $result['message'],
                    ]);
                }
            }
            

            if ($overdueDays == 25) {
                
                if(!$alreadyNotifiedStaff){
                    Notification::route('mail', 'muazpemajudigital@gmail.com')
                         ->notify(new ServiceSuspended($sub));
                         
                         $sub->notifications()->create([
                            'id' => Str::uuid()->toString(),
                            'type' => ServiceSuspended::class,
                            'data' => [
                                'subscription_id' => $sub->id,
                                'message' => 'Client suspended',
                            ],
                        ]);
                }
                
                if(!$alreadyNotifiedClient){

                    $sub->notify(new ServiceSuspendedClient($sub));
                        
                        $sub->notifications()->create([
                            'id' => Str::uuid()->toString(),
                            'type' => ServiceSuspendedClient::class,
                            'data' => [
                                'subscription_id' => $sub->id,
                                'message' => 'Client suspended',
                            ],
                        ]);
                }
                
                $this->info("Subscription #{$sub->id} suspended.");
           }
        }
        }
    }

    private function getNextRetryDate($count)
    {
        return match ($count) {
            1 => now()->addDays(1), // hari ke-1
            2 => now()->addDays(2), // hari ke-3
            3 => now()->addDays(4), // hari ke-7
            4 => now()->addDays(3), // hari ke-10
            5 => now()->addDays(5), // hari ke-15
            6 => now()->addDays(5), // hari ke-20
            7 => now()->addDays(5), // hari ke-25
            default => null
        };
    }
}
