<?php

namespace App\Console\Commands;

use App\Models\Subscription;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class CheckSubscriptionStatus extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'subscriptions:check_status';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $today = Carbon::today();

        // Ambil semua subscription yang aktif atau overdue
        $subs = Subscription::whereIn('status', ['paid', 'overdue'])->get();
        
        
            
            
        

        foreach ($subs as $sub) {

            $daysOverdue = $today->diffInDays($sub->next_charge_date, false);

            Log::info('Webhook failed at ' . now()->toDateTimeString(), [
                'subs' => $subs,
                'reason' => 'CheckSubscriptionStatus',
                'daysOverDue' => abs($daysOverdue)
            ]);
            if ($daysOverdue < 0) { 
                // sudah overdue
                $daysLate = abs($daysOverdue);

                if ($daysLate >= 25) {
                    $sub->update(['status' => 'suspended']);
                    $this->info("Subscription of {$sub->email} suspended.");
                } else {
                    $sub->update(['status' => 'overdue']);
                    $this->info("Subscription of {$sub->email} overdue ({$daysLate} days).");
                }
            } else {
                // masih paid (belum overdue)
                if ($sub->status !== 'paid') {
                    $sub->update(['status' => 'paid']);
                }
            }
        }

        return Command::SUCCESS;
    }
}
