<?php

namespace App\Console\Commands;

use App\Http\Controllers\PaymentController;
use App\Models\Subscription;
use App\Services\ChipService;
use Illuminate\Console\Command;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Support\Facades\Http;

class ChargeSubscriptions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */

    /**
     * The console command description.
     *
     * @var string
     */

    /**
     * Execute the console command.
     */
    protected $signature = 'subscriptions:charge';
    protected $description = 'Charge all subscriptions due today';

    protected ChipService $chipService;

    public function __construct(ChipService $chipService)
    {
        parent::__construct();
        $this->chipService = $chipService;
    }

    public function handle()
    {
        $this->chipService->chargeMonthly(); 
    }
        
}